document.addEventListener("DOMContentLoaded", function () {
	// Deklarasi semua elemen
	const userIcon = document.querySelector("#openLoginModal");
	const modal = document.getElementById("loginModal");
	const modalChoice = document.getElementById("modalChoice");
	const modalLogin = document.getElementById("modalLogin");
	const closeModal = document.querySelector(".close");
	const loginFormBtn = document.getElementById("loginFormBtn");
	const externalLinkBtn = document.getElementById("externalLinkBtn");
	const loginForm = document.querySelector(".user");
	const navMenu = document.querySelector(".nav-menu");
	const hamburger = document.querySelector(".hamburger");

	// Toggle Hamburger Menu
	if (hamburger && navMenu) {
		hamburger.addEventListener("click", () => {
			hamburger.classList.toggle("active");
			navMenu.classList.toggle("active");
		});
	}

	// Fungsi untuk membuka modal dan menutup navbar
	if (userIcon && modal) {
		userIcon.addEventListener("click", (e) => {
			e.preventDefault();
			// Buka modal
			modal.style.display = "block";
			if (modalChoice) modalChoice.style.display = "flex";
			if (modalLogin) modalLogin.style.display = "none";
			// Tutup navbar jika terbuka
			if (navMenu.classList.contains("active")) {
				navMenu.classList.remove("active");
				hamburger.classList.remove("active");
			}
		});
	}

	// Tutup modal dengan tombol close
	if (closeModal && modal) {
		closeModal.addEventListener("click", () => {
			modal.style.display = "none";
		});
	}

	// Tutup modal saat klik di luar konten
	if (modal) {
		window.addEventListener("click", (event) => {
			if (event.target === modal) {
				modal.style.display = "none";
			}
		});
	}

	// Tombol Login dengan Username
	if (loginFormBtn && modalChoice && modalLogin) {
		loginFormBtn.addEventListener("click", () => {
			modalChoice.style.display = "none";
			modalLogin.style.display = "block";
		});
	}

	// Tombol Login Eksternal
	if (externalLinkBtn) {
		externalLinkBtn.addEventListener("click", () => {
			window.location.href = "https://example.com/login";
		});
	}

	// Handle form submission dengan AJAX
	if (loginForm) {
		loginForm.addEventListener("submit", function (e) {
			e.preventDefault();
			const formData = new FormData(this);

			fetch(this.action, {
				method: "POST",
				body: formData,
				headers: {
					"X-Requested-With": "XMLHttpRequest",
				},
			})
				.then((response) => {
					if (!response.ok) throw new Error("Network response was not ok");
					return response.json();
				})
				.then((data) => {
					console.log("Response from server:", data);
					if (data.success) {
						console.log("Redirecting to:", data.redirect);
						window.location.href = data.redirect;
					} else {
						const errorMessage = document.getElementById("errorMessage");
						if (errorMessage) {
							errorMessage.innerHTML = `<div class="alert alert-danger">${
								data.message || "Login gagal, periksa kembali input Anda."
							}</div>`;
						}
						if (modal && modalLogin) {
							modal.style.display = "block";
							modalLogin.style.display = "block";
						}
					}
				})
				.catch((error) => {
					console.error("Error:", error);
					const errorMessage = document.getElementById("errorMessage");
					if (errorMessage) {
						errorMessage.innerHTML =
							'<div class="alert alert-danger">Terjadi kesalahan, silakan coba lagi.</div>';
					}
					if (modal && modalLogin) {
						modal.style.display = "block";
						modalLogin.style.display = "block";
					}
				});
		});
	}

	// Handle klik pada artikel-item
	const artikelItems = document.querySelectorAll(".artikel-item");
	if (artikelItems) {
		artikelItems.forEach((item) => {
			item.addEventListener("click", function (e) {
				// Cegah aksi jika klik pada tautan "Baca Selengkapnya"
				if (e.target.closest(".artikel-link")) {
					return; // Biarkan tautan berfungsi normal
				}

				// Ambil URL dari atribut data-url
				const url = this.getAttribute("data-url");
				if (url) {
					window.location.href = url; // Arahkan ke URL
				}
			});
		});
	}

	// Sesuaikan tinggi nav menu (opsional)
	function adjustNavMenuHeight() {
		if (navMenu && window.innerWidth <= 790) {
			const navbar = document.querySelector(".navbar");
			if (navbar) {
				const navbarHeight = navbar.offsetHeight;
				const windowHeight = window.innerHeight;
				const maxHeight = windowHeight - navbarHeight - 10;
				navMenu.style.maxHeight = `${maxHeight}px`;
			}
		} else if (navMenu) {
			navMenu.style.maxHeight = "";
		}
	}

	window.addEventListener("load", adjustNavMenuHeight);
	window.addEventListener("resize", adjustNavMenuHeight);
});
